const express = require("express");

const connectDB = require("./config/config");

const Book = require("./models/book");

const app = express();

connectDB();

app.use(express.json());

app.post("/api/books", async (req, res) => {// cria uma rota HTTP do tipo POST, usada para enviar dados ao Servidor
  try {
    const { title, author, year, genre } = req.body; // Pega os campos  título, autor e etc. da requisição
    const newBook = new Book({ title, author, year, genre });// criamos um novo objeto (um novo livro)
    await newBook.save(); // salvando o livro no meu BD; await = espera salvar antes de continuar o código
    res.status(201).json(newBook);//deu bom, envia os dados do novo livro no formato JSON
  } catch (err) { //aqui é se der ruim
    res.status(500).json({ error: "Erro ao criar livro" });
  }
 });

 app.get("/api/books", async (_req, res) => { // Definindo a rota
  try {
    const books = await Book.find(); // buscando livros no BD - veja a apostila para mais explicações
    res.json(books);// envia a lista de livros ao cliente no formato json
  } catch (err) { // aqui é se dar ruim
    res.status(500).json({ error: "Erro ao buscar livros" });
  }
 });


app.listen(3000, () => console.log("Server running on port 3000"));
app.use(express.static("public"));