// models/Book.js

const mongoose = require('mongoose');

/**
 * Defines the schema for the Book collection in MongoDB.
 * A schema maps to a MongoDB collection and defines the shape of the documents within that collection.
 */
const bookSchema = new mongoose.Schema({
  title: { type: String},
  author: { type: String },
  year: { type: Number },
  genre: { type: String },
  createdAt: { type: Date, default: Date.now }
});

const Book = mongoose.model('Book', bookSchema);
module.exports = Book;