// ================= JOGO DA MEMÓRIA (SIMPLES) =================
// Objetivo: encontrar todos os pares de heróis.

// Lista de heróis (basta adicionar mais nomes + imagens para expandir)
const heroes = ['hero1', 'hero2', 'hero3', 'hero4', 'hero5', 'hero6'];

// Estado básico
let primeira = null;
let travado = false;
let jogadas = 0;
let acertos = 0;

// Referências a elementos
const movesEl = document.getElementById('moves');
const matchEl = document.getElementById('matches');
const area = document.getElementById('game');

// Embaralha array (Fisher-Yates)
function embaralhar(arr) {
  for (let i = arr.length - 1; i > 0; i--) {
    const j = Math.floor(Math.random() * (i + 1));
    [arr[i], arr[j]] = [arr[j], arr[i]];
  }
  return arr;
}

// Cria elemento de carta
function criarCarta(nome) {
  const c = document.createElement('button');
  c.className = 'card';
  c.dataset.hero = nome;
  c.textContent = '?';
  c.onclick = () => virar(c);
  return c;
}

// Atualiza painel
function atualizar() {
  movesEl.textContent = jogadas;
  matchEl.textContent = acertos;
}

// Inicia / reinicia jogo
function iniciar() {
  area.innerHTML = '';
  primeira = null;
  travado = false;
  jogadas = 0;
  acertos = 0;
  atualizar();
  embaralhar([...heroes, ...heroes])
    .forEach(h => area.appendChild(criarCarta(h)));
}

// Ação ao clicar
function virar(c) {
  if (travado || c.classList.contains('revelada') || c.classList.contains('certa')) return;

  c.classList.add('revelada');
  c.innerHTML = `<img src="images/heros/${c.dataset.hero}.png" alt="${c.dataset.hero}" style="max-width:70%;">`;

  if (!primeira) { // primeira carta
    primeira = c;
    return;
  }

  // segunda carta
  jogadas++;
  atualizar();

  if (primeira.dataset.hero === c.dataset.hero) { // par certo
    primeira.classList.add('certa');
    c.classList.add('certa');
    acertos++;
    primeira = null;
    atualizar();
    if (acertos === heroes.length) {
      setTimeout(() => alert(`Fim! Você concluiu em ${jogadas} tentativas.`), 200);
    }
  } else { // não é par
    travado = true;
    setTimeout(() => {
      esconder(primeira);
      esconder(c);
      primeira = null;
      travado = false;
    }, 800);
  }
}

function esconder(c) {
  c.classList.remove('revelada');
  c.textContent = '?';
}

// Eventos
document.getElementById('restartBtn').onclick = iniciar;
window.addEventListener('DOMContentLoaded', iniciar);
