document.addEventListener('DOMContentLoaded', () => {
    // ... (mesmo código para selecionar elementos e alternar formulários) ...

    const loginForm = document.getElementById('login-form');
    const registerForm = document.getElementById('register-form');
    const messageDiv = document.getElementById('message');
    const showRegisterLink = document.getElementById('show-register');
    const showLoginLink = document.getElementById('show-login');
    const loginContainer = document.getElementById('login-form-container');
    const registerContainer = document.getElementById('register-form-container');

    // Como o frontend e o backend estão na mesma origem, podemos usar uma URL relativa.
    const API_URL = '/api';

    showRegisterLink.addEventListener('click', (e) => {
        e.preventDefault();
        loginContainer.classList.add('hidden');
        registerContainer.classList.remove('hidden');
        messageDiv.textContent = '';
    });

    showLoginLink.addEventListener('click', (e) => {
        e.preventDefault();
        registerContainer.classList.add('hidden');
        loginContainer.classList.remove('hidden');
        messageDiv.textContent = '';
    });

    // Formulário de REGISTRO
    registerForm.addEventListener('submit', async (e) => {
        e.preventDefault();
        const email = document.getElementById('register-email').value;
        const password = document.getElementById('register-password').value;

        const response = await fetch(`${API_URL}/register`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ email, password })
        });
        const data = await response.json();
        messageDiv.textContent = data.message;
        messageDiv.style.color = response.ok ? 'green' : 'red';
    });

    // Formulário de LOGIN
    loginForm.addEventListener('submit', async (e) => {
        e.preventDefault();
        const email = document.getElementById('login-email').value;
        const password = document.getElementById('login-password').value;
        
        const response = await fetch(`${API_URL}/login`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ email, password })
        });
        const data = await response.json();
        messageDiv.textContent = data.message;
        messageDiv.style.color = response.ok ? 'green' : 'red';

        if (response.ok) {
            alert("Login bem-sucedido! Redirecionando...");
        }
    });
});