const express = require('express');
const app = express();
const connectDB = require('./config/db');
const bookRoutes = require('./routes/bookRoutes');


const PORT = process.env.PORT || 3000;


// conectar ao banco
connectDB();


// middlewares
app.use(express.json());


// rotas
app.use('/api', bookRoutes);


app.get('/', (req, res) => {
res.send('API Biblioteca Digital - rota /api/books');
});


app.listen(PORT, () => {
console.log(`Server running on port ${PORT}`);
});