// models/Book.js

const mongoose = require('mongoose');

/**
 * Defines the schema for the Book collection in MongoDB.
 * A schema maps to a MongoDB collection and defines the shape of the documents within that collection.
 */
const bookSchema = new mongoose.Schema({
  // 'title' field: must be a String and is required.
  title: {
    type: String,
    required: [true, 'Title is a required field.'], // Provides a custom error message
  },
  // 'author' field: must be a String and is required.
  author: {
    type: String,
    required: [true, 'Author is a required field.'],
  },
  // 'year' field: must be a Number, but it is not required.
  year: {
    type: Number,
  },
});

/**
 * Creates a Mongoose model based on the schema.
 * A model is a class with which we construct documents. In this case, each document will be a book with properties and behaviors as declared in our schema.
 * The first argument is the singular name of the collection your model is for.
 * Mongoose automatically looks for the plural, lowercased version of your model name. Thus, for the model 'Book', the collection will be 'books'.
 */
module.exports = mongoose.model('Book', bookSchema);