// config/config.js

const mongoose = require('mongoose');

/**
 * Asynchronously connects to the MongoDB database.
 * It uses the connection string for a local MongoDB instance.
 * If the connection fails, it logs the error and exits the process.
 */
const connectDB = async () => {
  try {
    // Attempt to connect to the MongoDB server.
    // 'minhaLivrariaDB' is the database name. It will be created if it doesn't exist.
    await mongoose.connect('mongodb://localhost:27017/minhaLivrariaDB');
    console.log('MongoDB connected successfully!');
  } catch (err) {
    // If an error occurs during connection, log it to the console.
    console.error('Error connecting to MongoDB:', err.message);
    
    // Exit the Node.js process with a failure code (1).
    // This is important because the application cannot run without the database.
    process.exit(1);
  }
};

// Export the function to be used in other parts of the application.
module.exports = connectDB;