// --- 1. Selecionar os elementos do HTML ---
const citacaoElemento = document.getElementById('citacao');
const autorElemento = document.getElementById('autor');
const novaCitacaoBtn = document.getElementById('novaCitacaoBtn');
const bodyElemento = document.body;

// --- 2. Criar uma lista (array) de citações ---
// Cada citação é um objeto com o texto e o autor.
const citacoes = [
    {
        texto: "A persistência é o caminho do êxito.",
        autor: "Charles Chaplin",
        imagem: "https://images.unsplash.com/photo-1470770841072-f978cf4d019e?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&q=80&w=1080"
    },
    {
        texto: "O sucesso é a soma de pequenos esforços repetidos dia após dia.",
        autor: "Robert Collier",
        imagem: "https://images.unsplash.com/photo-1444703686981-a3abbc4d4fe3?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&q=80&w=1080"
    },
    {
        texto: "Se você quer viver uma vida feliz, amarre-se a um objetivo, não às pessoas ou às coisas.",
        autor: "Albert Einstein",
        imagem: "https://images.unsplash.com/photo-1484199316358-d7acb93729f2?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&q=80&w=1080"
    },
    {
        texto: "A imaginação é mais importante que o conhecimento.",
        autor: "Albert Einstein",
        imagem: "https://images.unsplash.com/photo-1505144808419-1957a94ca61e?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&q=80&w=1080"
    },
    {
        texto: "A única maneira de fazer um ótimo trabalho é amar o que você faz.",
        autor: "Steve Jobs",
        imagem: "https://images.unsplash.com/photo-1519681393784-d120267933ba?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&q=80&w=1080"
    }
];

// --- 3. Função para gerar uma nova citação ---
function gerarNovaCitacao() {
    // Gerar um índice aleatório para pegar uma citação da lista
    const indiceAleatorio = Math.floor(Math.random() * citacoes.length);

    // Pegar a citação aleatória
    const citacaoSorteada = citacoes[indiceAleatorio];

    // Atualizar o HTML com a nova citação e autor
    citacaoElemento.textContent = `"${citacaoSorteada.texto}"`;
    autorElemento.textContent = `- ${citacaoSorteada.autor}`;

    // Atualizar a imagem de fundo do corpo da página
    bodyElemento.style.backgroundImage = `url('${citacaoSorteada.imagem}')`;
}

// --- 4. Adicionar o "ouvinte de evento" ao botão ---
// Isso faz com que a função 'gerarNovaCitacao' seja chamada toda vez que o botão for clicado.
novaCitacaoBtn.addEventListener('click', gerarNovaCitacao);