// script.js

// Lista de produtos
const PRODUTOS = [
    { id: 1, nome: 'Caneca',  preco: 10,  img: 'img/caneca.jpg',  desc: 'Uma caneca legal do Naruto' },
    { id: 2, nome: 'Camisa',  preco: 40,  img: 'img/camisa.jpeg', desc: 'Camisa do Star Wars' },
    { id: 3, nome: 'Boné',    preco: 30,  img: 'img/bone.jpg',    desc: 'Boné Gamer' },
    { id: 4, nome: 'Boneco',  preco: 140, img: 'img/shazan.jpg',  desc: 'Action figure do Shazam' }
];

// Estado do carrinho (id -> quantidade)
let carrinho = {};

// Referências do DOM
const grid       = document.getElementById('produtos');
const listaItens = document.getElementById('itens');
const totalEl    = document.getElementById('total');
const cartCount  = document.getElementById('cartCount');
const secCarrinho = document.getElementById('carrinho');
const btnCart    = document.getElementById('cartBtn');
const btnFinalizar = document.getElementById('finalizar');

// Formata preço em reais
function formatar(preco) {
    return 'R$ ' + preco.toFixed(2).replace('.', ',');
}

// Mostra os cards de produto na tela
function mostrarProdutos() {
    let html = '';

    for (const p of PRODUTOS) {
        html += `
        <article class="card">
            <img src="${p.img}" alt="${p.nome}">
            <h3>${p.nome}</h3>
            <p>${p.desc}</p>
            <p><strong>${formatar(p.preco)}</strong></p>
            <button onclick="adicionar(${p.id})">Adicionar</button>
        </article>
        `;
    }

    grid.innerHTML = html;
}

// Adiciona 1 unidade do produto ao carrinho
function adicionar(id) {
    if (!carrinho[id]) {
        carrinho[id] = 0;
    }
    carrinho[id]++;
    atualizarCarrinho();
}

// Remove 1 unidade do produto do carrinho
function remover(id) {
    if (!carrinho[id]) return;

    carrinho[id]--;

    if (carrinho[id] <= 0) {
        delete carrinho[id];
    }

    atualizarCarrinho();
}

// Atualiza a lista de itens e o total
function atualizarCarrinho() {
    listaItens.innerHTML = '';
    let total = 0;
    let quantidadeTotal = 0;

    for (const id in carrinho) {
        const produto = PRODUTOS.find(p => p.id === Number(id));
        const qtd = carrinho[id];
        const subtotal = produto.preco * qtd;

        const li = document.createElement('li');
        li.textContent = `${produto.nome} x ${qtd} - ${formatar(subtotal)} `;

        const botaoRemover = document.createElement('button');
        botaoRemover.textContent = 'Remover 1';
        botaoRemover.onclick = function () {
            remover(produto.id);
        };

        li.appendChild(botaoRemover);
        listaItens.appendChild(li);

        total += subtotal;
        quantidadeTotal += qtd;
    }

    totalEl.textContent = formatar(total);
    cartCount.textContent = quantidadeTotal;
}

// Mostrar / esconder carrinho
btnCart.onclick = function () {
    secCarrinho.classList.toggle('hidden');
};

// Finalizar compra
btnFinalizar.onclick = function () {
    if (listaItens.children.length === 0) {
        alert('Carrinho vazio');
        return;
    }

    alert('Pedido enviado! Total: ' + totalEl.textContent);

    carrinho = {};
    atualizarCarrinho();
    secCarrinho.classList.add('hidden');
};

// Iniciar página
mostrarProdutos();
atualizarCarrinho();
