extends CharacterBody3D


const SPEED = 200.0
const JUMP_VELOCITY = 10
@onready var animator = get_node('gobot/AnimationPlayer')as AnimationPlayer

@export var view : Node3D
var gravity = 0
var movement_velocity : Vector3
var rotation_direction : float

# Get the gravity from the project settings to be synced with RigidBody nodes.
#var gravity = ProjectSettings.get_setting("physics/3d/default_gravity")

func handle_input(delta):
	var input := Vector3.ZERO
	input.x = Input.get_axis('ui_left', 'ui_right')
	input.z = Input.get_axis('ui_up', 'ui_down')
	
	input = input.rotated(Vector3.UP, view.rotation.y).normalized()
	
	velocity = input * SPEED * delta

func handle_animations():
	if is_on_floor():
		if abs(velocity.x)>1 or abs(velocity.z)>1:
			animator.play('Run', 0.3)
		else:
			animator.play('Idle', 0.3)
			
func apply_gravity(delta):
	if not is_on_floor():
		gravity += 25 * delta
func _physics_process(delta):
	handle_input(delta)
	apply_gravity(delta)
	handle_animations()
	move_and_slide()
